/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.util.Assert;

public class LogbackUtils {
    private LogbackUtils() {
    }

    public static LoggerContext getLoggerContext() {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s). If you are using WebLogic you will need to add 'org.slf4j' to prefer-application-packages in WEB-INF/weblogic.xml", factory.getClass(), LogbackUtils.getLocation(factory)));
        return (LoggerContext)factory;
    }

    private static Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return "unknown location";
    }

    public static Logger getRootLogger() {
        return LogbackUtils.getLogger("ROOT");
    }

    public static List<Logger> getLoggers() {
        return LogbackUtils.getLoggerContext().getLoggerList();
    }

    public static Logger getLogger(String loggerName) {
        LoggerContext factory = LogbackUtils.getLoggerContext();
        if (StringUtils.isEmpty(loggerName) || "ROOT".equals(loggerName)) {
            loggerName = "ROOT";
        }
        return factory.getLogger(loggerName);
    }

    public static void setLogLevel(String loggerName, Level level) {
        Logger logger = LogbackUtils.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel(level);
        }
    }
}

