/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.springframework.util.StringUtils;

public class Log4j2Utils {
    private Log4j2Utils() {
    }

    public static LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext();
    }

    public static List<LoggerConfig> getLoggers() {
        ArrayList<LoggerConfig> loggerConfigs = new ArrayList<LoggerConfig>();
        Configuration configuration = Log4j2Utils.getLoggerContext().getConfiguration();
        for (LoggerConfig loggerConfig : configuration.getLoggers().values()) {
            loggerConfigs.add(loggerConfig);
        }
        return loggerConfigs;
    }

    public static LoggerConfig getRootLogger() {
        return Log4j2Utils.getLogger("ROOT");
    }

    public static LoggerConfig getLogger(String loggerName) {
        if (!StringUtils.hasLength((String)loggerName) || "ROOT".equals(loggerName)) {
            loggerName = "";
        }
        return (LoggerConfig)Log4j2Utils.getLoggerContext().getConfiguration().getLoggers().get(loggerName);
    }

    public static void setLogLevel(String loggerName, Level level) {
        LoggerConfig loggerConfig = Log4j2Utils.getLogger(loggerName);
        if (loggerConfig == null) {
            loggerConfig = new LoggerConfig(loggerName, level, true);
            Log4j2Utils.getLoggerContext().getConfiguration().addLogger(loggerName, loggerConfig);
        } else {
            loggerConfig.setLevel(level);
        }
        Log4j2Utils.getLoggerContext().updateLoggers();
    }
}

