/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class IOExtUtils {
    public static InputStream copy(InputStream is) throws IOException {
        int len;
        Objects.requireNonNull(is, "inputStream must not be null!");
        if (!is.markSupported()) {
            throw new IllegalArgumentException(is.getClass().getName() + " do not support mark, you can wrapper java.io.BufferedInputStream");
        }
        is.mark(Integer.MAX_VALUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        is.reset();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

