/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.http;

import cn.chenzw.toolkit.http.HttpHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ResponseUtils {
    private static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    private ResponseUtils() {
    }

    public static void download(String fileName, InputStream inputStream) throws IOException {
        ResponseUtils.download(fileName, inputStream, Charset.defaultCharset());
    }

    public static void download(String fileName, InputStream inputStream, Charset charset) throws IOException {
        ResponseUtils.download(null, fileName, inputStream, charset);
    }

    public static void download(HttpServletResponse response, String fileName, InputStream inputStream, Charset charset) throws IOException {
        if (response == null) {
            response = HttpHolder.getResponse();
        }
        response.setContentType(OCTET_STREAM_CONTENT_TYPE + (charset != null ? ";charset=" + charset.name() : ""));
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"; filename*=utf-8''" + fileName);
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
    }

    public static String buildHtmlMsg(String title, String msg) {
        return ResponseUtils.buildHtmlMsg(title, null, msg);
    }

    public static String buildHtmlMsg(String title, String tip, String msg) {
        return "<div style=\"position: relative; width: 100%; height: 500px; text-align:center;\"><div style=\" width: 300px; margin: 100px auto; padding: 10px; border: 1px solid #ccc; border-radius: 5px; overflow: hidden;\"><div style=\"padding: 10px 3px; border-bottom: 1px solid #ccc; font-weight: bold;\">" + title + "</div><div style=\"padding: 10px 3px;\">" + (StringUtils.isEmpty(tip) ? "" : "\u3010" + tip + "\u3011: ") + msg + "</div></div></div>";
    }

    public static void printHtmlMsg(HttpServletResponse response, String title, String tip, String msg) {
        response.setContentType("text/html");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try {
            response.getWriter().write(ResponseUtils.buildHtmlMsg(title, tip, msg));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

