/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestUtils {
    private static final String[] CLIENT_IP_HEADERS = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR", "X-Real-IP"};

    private RequestUtils() {
    }

    public static String getFirstParamter(Object params) {
        if (params instanceof String[]) {
            if (params == null || ArrayUtils.isEmpty((String[])params)) {
                return "";
            }
            return ((String[])params)[0];
        }
        return (String)params;
    }

    public static String getClientIp(HttpServletRequest request) {
        for (String clientIpHeader : CLIENT_IP_HEADERS) {
            String ip = request.getHeader(clientIpHeader);
            if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }
}

