/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.http;

import cn.chenzw.toolkit.http.HttpHolder;
import cn.chenzw.toolkit.http.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestWrapper {
    private static final String POST_METHOD = "POST";
    private static final String MULTIPART = "multipart/";
    private static final String X_REQUESTED_WIDTH_HEADER = "X-Requested-With";
    private static final String AJAX_HEADER = "XMLHttpRequest";
    private HttpServletRequest request;

    public HttpRequestWrapper() {
        this.request = HttpHolder.getRequest();
        if (this.request == null) {
            throw new IllegalArgumentException("HttpServletRequest must not be null");
        }
    }

    public HttpRequestWrapper(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest must not be null");
        }
        this.request = request;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getURI() {
        return this.request.getRequestURI();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getURL() {
        return this.request.getRequestURL().toString();
    }

    public String getClientIp() {
        return RequestUtils.getClientIp(this.request);
    }

    public long getThreadId() {
        return Thread.currentThread().getId();
    }

    public String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String getBodyString() throws IOException {
        if (this.isMultipart(this.request)) {
            return "";
        }
        return IOUtils.toString((InputStream)this.request.getInputStream(), (String)"UTF-8");
    }

    private boolean isMultipart(HttpServletRequest request) {
        if (!POST_METHOD.equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (StringUtils.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public boolean isAjax() {
        return AJAX_HEADER.equalsIgnoreCase(this.request.getHeader(X_REQUESTED_WIDTH_HEADER));
    }
}

