/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.http;

import cn.chenzw.toolkit.spring.util.SpringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpHolder {
    private static final ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();

    private HttpHolder() {
    }

    public static void init(HttpServletRequest request, HttpServletResponse response) {
        REQUEST.set(request);
        RESPONSE.set(response);
    }

    public static HttpServletRequest getRequest() {
        if (REQUEST.get() == null) {
            return HttpHolder.getRequestInternal();
        }
        return REQUEST.get();
    }

    public static HttpServletResponse getResponse() {
        if (RESPONSE.get() == null) {
            return HttpHolder.getResponseInternal();
        }
        return RESPONSE.get();
    }

    public static void clear() {
        REQUEST.remove();
        RESPONSE.remove();
    }

    private static HttpServletRequest getRequestInternal() {
        if (SpringUtils.SPRING_WEB_FRAME_PRESENT) {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        return null;
    }

    private static HttpServletResponse getResponseInternal() {
        if (SpringUtils.SPRING_WEB_FRAME_PRESENT) {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        }
        return null;
    }
}

