/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCachingRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ContentCachingRequestWrapper.class);
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public ContentCachingRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)this.baos);
        }
        catch (IOException e) {
            logger.error("HttpRequest caching with error!", e);
        }
    }

    @Override
    public ServletInputStream getInputStream() {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.baos.toByteArray());
        return new ServletInputStream(){

            @Override
            public boolean isFinished() {
                return false;
            }

            @Override
            public boolean isReady() {
                return false;
            }

            @Override
            public void setReadListener(ReadListener readListener) {
            }

            @Override
            public int read() {
                return bais.read();
            }
        };
    }
}

