/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.hbase;

import cn.chenzw.toolkit.hbase.HBaseConnectionHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUtils {
    private static Logger logger = LoggerFactory.getLogger(HBaseUtils.class);

    public static boolean createTable(Configuration configuration, String tableName, List<String> columnFamily, boolean deleteIfExists) throws IOException {
        TableName name;
        Connection connection = HBaseConnectionHolder.get(configuration);
        Admin admin = connection.getAdmin();
        if (admin.tableExists(name = TableName.valueOf((String)tableName))) {
            logger.debug("Htable [{}] already exists!", (Object)tableName);
            if (deleteIfExists) {
                admin.disableTable(name);
                admin.deleteTable(name);
                logger.debug("Delete htable [{}]!", (Object)tableName);
            } else {
                return false;
            }
        }
        admin.createTable(HBaseUtils.createTableDescriptor(name, columnFamily));
        return true;
    }

    public List<String> listAllTableNames() {
        return null;
    }

    private static TableDescriptor createTableDescriptor(TableName name, List<String> columnFamily) {
        ArrayList familyDescriptors = new ArrayList(columnFamily.size());
        columnFamily.forEach(cf -> familyDescriptors.add(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)cf)).build()));
        return TableDescriptorBuilder.newBuilder((TableName)name).setColumnFamilies(familyDescriptors).build();
    }
}

