/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.freemarker.builder;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FreeMarkerBuilder {
    private Configuration configuration;
    private Version version;
    private String templatePath;
    private String templateName;
    private TemplateExceptionHandler templateExceptionHanler;
    private Locale locale;
    private String encoding;
    private String templateContent;

    private FreeMarkerBuilder() {
    }

    private FreeMarkerBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public static FreeMarkerBuilder create() {
        return new FreeMarkerBuilder();
    }

    public static FreeMarkerBuilder createByConfiguration(Configuration configuration) {
        return new FreeMarkerBuilder(configuration);
    }

    public FreeMarkerBuilder version(Version version) {
        this.version = version;
        return this;
    }

    public FreeMarkerBuilder templatePath(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public FreeMarkerBuilder templateExceptionHanler(TemplateExceptionHandler templateExceptionHanler) {
        this.templateExceptionHanler = templateExceptionHanler;
        return this;
    }

    public FreeMarkerBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public FreeMarkerBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public FreeMarkerBuilder templateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public FreeMarkerBuilder templateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public Template build() throws IOException {
        if (this.configuration == null) {
            this.configuration = new Configuration(ObjectUtils.defaultIfNull(this.version, Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS));
        }
        if (!StringUtils.isEmpty(this.templatePath)) {
            this.configuration.setDirectoryForTemplateLoading(new File(this.templatePath));
        }
        if (!StringUtils.isEmpty(this.templateContent)) {
            StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
            stringTemplateLoader.putTemplate(this.templateName, this.templateContent);
            this.configuration.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        }
        if (this.templateExceptionHanler != null) {
            this.configuration.setTemplateExceptionHandler(this.templateExceptionHanler);
        }
        if (this.locale != null) {
            this.configuration.setLocale(this.locale);
        }
        if (!StringUtils.isEmpty(this.encoding)) {
            this.configuration.setEncoding(this.configuration.getLocale(), this.encoding);
        }
        return this.configuration.getTemplate(this.templateName);
    }
}

