/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.freemarker;

import cn.chenzw.toolkit.freemarker.builder.FreeMarkerBuilder;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.Validate;

public abstract class FreeMarkerUtils {
    private FreeMarkerUtils() {
    }

    public static String processToString(File templateFile, Object dataModel) throws IOException, TemplateException {
        return FreeMarkerUtils.processToString(templateFile, dataModel, null);
    }

    public static String processToString(File templateFile, Object dataModel, FreeMarkerBuilder freeMarkerBuilder) throws IOException, TemplateException {
        return FreeMarkerUtils.processToString(FreeMarkerUtils.toTemplate(templateFile, freeMarkerBuilder), dataModel);
    }

    public static String processToString(Template template, Object dataModel) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        template.process(dataModel, (Writer)writer);
        return writer.toString();
    }

    public static String processToString(String templateContent, Object dataModel) throws IOException, TemplateException {
        return FreeMarkerUtils.processToString(FreeMarkerUtils.toTemplate(templateContent, null), dataModel);
    }

    public static String processToString(String templateContent, Object dataModel, FreeMarkerBuilder freeMarkerBuilder) throws IOException, TemplateException {
        return FreeMarkerUtils.processToString(FreeMarkerUtils.toTemplate(templateContent, freeMarkerBuilder), dataModel);
    }

    public static void processToFile(File templateFile, Object dataModel, File outFile) throws IOException, TemplateException {
        FreeMarkerUtils.processToFile(templateFile, dataModel, outFile, null);
    }

    public static void processToFile(File templateFile, Object dataModel, File outFile, FreeMarkerBuilder freeMarkerBuilder) throws IOException, TemplateException {
        FreeMarkerUtils.processToFile(FreeMarkerUtils.toTemplate(templateFile, freeMarkerBuilder), dataModel, outFile);
    }

    public static void processToFile(Template template, Object dataModel, File outFile) {
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile)));){
            template.process(dataModel, (Writer)bufferedWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Template toTemplate(File templateFile, FreeMarkerBuilder freeMarkerBuilder) throws IOException {
        Validate.notNull(templateFile, "Freemarker template file is null !", new Object[0]);
        Validate.isTrue(templateFile.exists(), "Freemarker template file [ " + templateFile.getAbsolutePath() + "] is not exists!", new Object[0]);
        String templatePath = templateFile.getParentFile().getAbsolutePath();
        String templateName = templateFile.getName();
        if (freeMarkerBuilder == null) {
            return FreeMarkerBuilder.create().templatePath(templatePath).templateName(templateName).build();
        }
        return freeMarkerBuilder.templatePath(templatePath).templateName(templateName).build();
    }

    private static Template toTemplate(String templateContent, FreeMarkerBuilder freeMarkerBuilder) throws IOException {
        Validate.notEmpty(templateContent, "Freemarker templateContent is null!", new Object[0]);
        if (freeMarkerBuilder == null) {
            freeMarkerBuilder = FreeMarkerBuilder.create();
        }
        return freeMarkerBuilder.templateContent(templateContent).templateName("stringTemplate").build();
    }
}

