/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.dozer;

import cn.chenzw.toolkit.commons.GenericUtils;
import cn.chenzw.toolkit.dozer.core.DozerFieldMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dozer.CustomConverter;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.api.FieldsMappingOption;
import org.dozer.loader.api.FieldsMappingOptions;
import org.dozer.loader.api.TypeMappingBuilder;
import org.dozer.loader.api.TypeMappingOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public abstract class DozerUtils {
    private static final Logger logger = LoggerFactory.getLogger(DozerUtils.class);

    private DozerUtils() {
    }

    public static <T, S> List<T> mapList(Mapper mapper, List<S> sourceList, Class<T> targetClass) {
        if (sourceList == null || sourceList.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (S s : sourceList) {
            targetList.add(mapper.map(s, targetClass));
        }
        return targetList;
    }

    public static <T, S> List<T> mapList(List<S> sourceList, Class<T> targetClass) {
        DozerBeanMapper mapper = new DozerBeanMapper();
        return DozerUtils.mapList((Mapper)mapper, sourceList, targetClass);
    }

    public static <T, S> List<T> mapList(Mapper mapper, final List<S> sourceList, final Class<T> destClass, final List<DozerFieldMapping> dozerFieldMappings) {
        logger.debug("Dozer [{}] start mapList, source:{}, dest: {}", dozerFieldMappings, sourceList, destClass);
        long t1 = System.currentTimeMillis();
        if (sourceList == null || sourceList.isEmpty()) {
            return new ArrayList();
        }
        HashMap<String, CustomConverter> customConverterMap = new HashMap<String, CustomConverter>();
        for (DozerFieldMapping dozerFieldMapping : dozerFieldMappings) {
            customConverterMap.put(ObjectUtils.identityToString((Object)dozerFieldMapping), dozerFieldMapping.getConverter());
        }
        ((DozerBeanMapper)mapper).setCustomConvertersWithId(customConverterMap);
        BeanMappingBuilder builder = new BeanMappingBuilder(){

            protected void configure() {
                TypeMappingBuilder mapping = this.mapping(GenericUtils.getSuperClassGenricType(sourceList), destClass, new TypeMappingOption[0]);
                for (DozerFieldMapping dozerFieldMapping : dozerFieldMappings) {
                    mapping.fields(dozerFieldMapping.getSrcFieldName(), dozerFieldMapping.getDestFieldName(), new FieldsMappingOption[]{FieldsMappingOptions.customConverterId((String)ObjectUtils.identityToString((Object)dozerFieldMapping))});
                }
            }
        };
        ((DozerBeanMapper)mapper).addMapping(builder);
        List<T> rets = DozerUtils.mapList(mapper, sourceList, destClass);
        long t2 = System.currentTimeMillis();
        logger.debug("Dozer [{}] finsh mapList, cost {} ms", (Object)mapper, (Object)(t2 - t1));
        return rets;
    }
}

