/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.dial.http.okhttp;

import cn.chenzw.toolkit.dial.core.support.DialResponseResolver;
import cn.chenzw.toolkit.dial.http.DialHttpResponse;
import cn.chenzw.toolkit.dial.http.okhttp.OkHttpDialResponseResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.Response;

public class OkHttpDialResponse
implements DialHttpResponse {
    private Response response;
    private DialResponseResolver dialResponseResolver;

    public OkHttpDialResponse(Response response) {
        this.response = response;
        this.dialResponseResolver = new OkHttpDialResponseResolver(response);
    }

    public OkHttpDialResponse(Response response, DialResponseResolver dialResponseResolver) {
        this.response = response;
        this.dialResponseResolver = dialResponseResolver == null ? new OkHttpDialResponseResolver(response) : dialResponseResolver;
    }

    @Override
    public DialResponseResolver getResponseResolver() {
        return this.dialResponseResolver;
    }

    @Override
    public boolean isSuccessful() {
        return this.dialResponseResolver.isSuccessful();
    }

    @Override
    public void close() {
        this.response.close();
    }

    @Override
    public int code() {
        return this.response.code();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public String body() {
        try {
            return this.response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Headers headers = this.response.headers();
        Set names = headers.names();
        for (String name : names) {
            headerMap.put(name, headers.get(name));
        }
        return headerMap;
    }

    public String toString() {
        return "OkHttpDialResponse{code=" + this.code() + ", message=" + this.message() + '}';
    }
}

