/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.dial.http.okhttp;

import cn.chenzw.toolkit.dial.http.okhttp.OkHttpDialRequest;
import java.util.HashMap;
import java.util.Map;

public final class OkHttpDialRequestBuilder {

    public static final class Builder {
        private String url;
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        public Builder url(String url) {
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            this.url = url.regionMatches(true, 0, "ws:", 0, 3) ? "http:" + url.substring(3) : (url.regionMatches(true, 0, "wss:", 0, 4) ? "https:" + url.substring(4) : url);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder get() {
            this.method = "GET";
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public OkHttpDialRequest build() {
            return new OkHttpDialRequest(this.url, this.method, this.headers, this.data);
        }
    }
}

