/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.dial.http.okhttp;

import cn.chenzw.toolkit.dial.http.DialHttpRequest;
import java.util.Map;
import okhttp3.Request;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OkHttpDialRequest
implements DialHttpRequest {
    private String url;
    private String method;
    private Map<String, String> headers;
    private Object data;

    public static Request of(OkHttpDialRequest okHttpDialRequest) {
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotEmpty(okHttpDialRequest.getUrl())) {
            builder.url(okHttpDialRequest.getUrl());
        }
        if (StringUtils.isNotEmpty(okHttpDialRequest.getMethod())) {
            builder.method(okHttpDialRequest.getMethod(), null);
        }
        if (MapUtils.isNotEmpty(okHttpDialRequest.getHeaders())) {
            Map<String, String> headers = okHttpDialRequest.getHeaders();
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder.build();
    }

    public OkHttpDialRequest(String url, String method, Map<String, String> headers, Object data) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.data = data;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Object getData() {
        return this.data;
    }
}

