/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.dial.core;

import cn.chenzw.toolkit.dial.core.support.Callback;
import cn.chenzw.toolkit.dial.core.support.DialProcessor;
import cn.chenzw.toolkit.dial.core.support.DialRequest;
import cn.chenzw.toolkit.dial.core.support.DialResponse;
import cn.chenzw.toolkit.dial.core.support.DialResponseResolver;
import cn.chenzw.toolkit.dial.core.support.ExceptionCallback;
import cn.chenzw.toolkit.dial.http.DialHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DialProcessor dialProcessor;
    private Callback successCallback;
    private Callback failureCallback;
    private ExceptionCallback exceptionCallback;
    private DialResponseResolver dialResponseResolver;

    DialBuilder(Builder builder) {
        this.dialProcessor = builder.dialProcessor;
        this.successCallback = builder.successCallback;
        this.failureCallback = builder.failureCallback;
        this.exceptionCallback = builder.exceptionCallback;
        this.dialResponseResolver = builder.dialResponseResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DialRequest dialRequest) {
        DialResponse dialResponse = null;
        try {
            dialResponse = this.dialProcessor.execute(dialRequest, this.dialResponseResolver);
        }
        catch (Exception e) {
            if (this.exceptionCallback != null) {
                this.exceptionCallback.call(dialRequest, dialResponse, e);
            } else if (dialRequest instanceof DialHttpRequest) {
                DialHttpRequest dialHttpRequest = (DialHttpRequest)dialRequest;
                this.logger.error("[{}] process url [{}] with exception!", this.dialProcessor.getClass().getSimpleName(), dialHttpRequest.getUrl(), e);
            } else {
                this.logger.error("[{}] process with exception!", (Object)this.dialProcessor.getClass().getSimpleName(), (Object)e);
            }
            return;
        }
        try {
            if (dialResponse.isSuccessful()) {
                if (this.successCallback != null) {
                    this.successCallback.call(dialRequest, dialResponse);
                }
            } else if (this.failureCallback != null) {
                this.failureCallback.call(dialRequest, dialResponse);
            } else if (dialRequest instanceof DialHttpRequest) {
                DialHttpRequest dialHttpRequest = (DialHttpRequest)dialRequest;
                this.logger.error("[{}] process url [{}] with exception!", (Object)this.dialProcessor.getClass().getSimpleName(), (Object)dialHttpRequest.getUrl());
            } else {
                this.logger.warn("[{}] process fail!", (Object)this.dialProcessor.getClass().getSimpleName());
            }
        }
        finally {
            if (dialResponse != null) {
                dialResponse.close();
            }
        }
    }

    public static final class Builder {
        private DialProcessor dialProcessor;
        private Callback successCallback;
        private Callback failureCallback;
        private ExceptionCallback exceptionCallback;
        private DialResponseResolver dialResponseResolver;

        public Builder(DialProcessor dialProcessor) {
            this.dialProcessor = dialProcessor;
        }

        public Builder success(Callback successCallback) {
            this.successCallback = successCallback;
            return this;
        }

        public Builder failure(Callback failureCallback) {
            this.failureCallback = failureCallback;
            return this;
        }

        public Builder exception(ExceptionCallback exceptionCallback) {
            this.exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder responseResolver(DialResponseResolver dialResponseResolver) {
            this.dialResponseResolver = dialResponseResolver;
            return this;
        }

        public DialBuilder build() {
            return new DialBuilder(this);
        }
    }
}

