/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.datasource.core.factory;

import cn.chenzw.toolkit.datasource.core.builder.AbstractTableDefinitionBuilder;
import cn.chenzw.toolkit.datasource.entity.TableDefinition;
import cn.chenzw.toolkit.datasource.mysql.builder.MySqlTableDefinitionBuilder;
import cn.chenzw.toolkit.datasource.oracle.builder.OracleTableDefinitionBuilder;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class TableDefinitionFactory {
    private static Map<String, Class<?>> DRIVER_MAPPING = new HashMap();

    private TableDefinitionFactory() {
    }

    public static TableDefinition create(DataSource dataSource, String tableName) throws SQLException, InstantiationException {
        try (Connection connection = null;){
            connection = dataSource.getConnection();
            String driverName = connection.getMetaData().getDriverName();
            if (DRIVER_MAPPING.containsKey(driverName)) {
                Class<?> builderClass = DRIVER_MAPPING.get(driverName);
                try {
                    AbstractTableDefinitionBuilder tableDefinitionBuilder = (AbstractTableDefinitionBuilder)builderClass.getConstructor(Connection.class, String.class).newInstance(connection, tableName);
                    TableDefinition tableDefinition = tableDefinitionBuilder.build();
                    return tableDefinition;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new InstantiationException("Instantiation TableDefinitionBuilder fail!");
                }
            }
            throw new IllegalArgumentException("Missing found driver mapping of [" + driverName + "]");
        }
    }

    static {
        DRIVER_MAPPING.put("Oracle JDBC driver", OracleTableDefinitionBuilder.class);
        DRIVER_MAPPING.put("MySQL Connector Java", MySqlTableDefinitionBuilder.class);
    }
}

