/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.datasource.core.builder;

import cn.chenzw.toolkit.commons.StringExtUtils;
import cn.chenzw.toolkit.datasource.core.builder.AbstractColumnDefinitionBuilder;
import cn.chenzw.toolkit.datasource.entity.TableDefinition;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractTableDefinitionBuilder {
    private Connection connection;
    private String tableName;

    public AbstractTableDefinitionBuilder(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    protected String getTableName(ResultSet rs) throws SQLException {
        return rs.getString("TABLE_NAME");
    }

    protected String getRemarks(ResultSet rs) throws SQLException {
        return rs.getString("TABLE_NAME");
    }

    protected abstract AbstractColumnDefinitionBuilder getColumnDefinitionBuilder(Connection var1, String var2);

    public TableDefinition build() throws SQLException {
        ResultSet tableRs = this.connection.getMetaData().getTables(null, null, this.tableName, new String[]{"TABLE"});
        if (tableRs.next()) {
            String _tableName = this.getTableName(tableRs);
            return new TableDefinition(_tableName, StringExtUtils.toPascal(_tableName), this.getRemarks(tableRs), this.getColumnDefinitionBuilder(this.connection, this.tableName).build());
        }
        return null;
    }
}

