/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.datasource.core.builder;

import cn.chenzw.toolkit.commons.StringExtUtils;
import cn.chenzw.toolkit.datasource.core.converter.JdbcTypeConverter;
import cn.chenzw.toolkit.datasource.entity.ColumnDefinition;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractColumnDefinitionBuilder {
    private Connection connection;
    private String tableName;

    public AbstractColumnDefinitionBuilder(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    protected String getColumnName(ResultSet rs) throws SQLException {
        return rs.getString("COLUMN_NAME");
    }

    protected String getTypeName(ResultSet rs) throws SQLException {
        return rs.getString("TYPE_NAME");
    }

    protected Integer getColumnSize(ResultSet rs) throws SQLException {
        return rs.getInt("COLUMN_SIZE");
    }

    protected String getRemarks(ResultSet rs) throws SQLException {
        return rs.getString("REMARKS");
    }

    protected String getPrimaryKey(ResultSet rs) throws SQLException {
        return rs.getString("COLUMN_NAME");
    }

    protected String getForeignKey(ResultSet rs) throws SQLException {
        return rs.getString("FKCOLUMN_NAME");
    }

    protected Boolean isNullable(ResultSet rs) throws SQLException {
        return rs.getBoolean("IS_NULLABLE");
    }

    protected String getColumnDef(ResultSet rs) throws SQLException {
        return rs.getString("COLUMN_DEF");
    }

    protected Integer getDecimalDigits(ResultSet rs) throws SQLException {
        return rs.getInt("DECIMAL_DIGITS");
    }

    protected abstract JdbcTypeConverter getTypeConverter();

    public List<ColumnDefinition> build() throws SQLException {
        ResultSet columnRs = this.connection.getMetaData().getColumns(null, null, this.tableName, null);
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
        while (columnRs.next()) {
            String typeName = this.getTypeName(columnRs);
            Integer columnSize = this.getColumnSize(columnRs);
            Integer columnDigits = this.getDecimalDigits(columnRs);
            String columnName = this.getColumnName(columnRs);
            columnDefinitions.add(new ColumnDefinition(columnName, StringExtUtils.toCamel(columnName), typeName, columnSize, columnDigits, this.getRemarks(columnRs), null, null, this.isNullable(columnRs), this.getColumnDef(columnRs), this.getTypeConverter().toJavaType(typeName, columnSize, columnDigits)));
        }
        ResultSet primaryKeyRs = this.connection.getMetaData().getPrimaryKeys(null, null, this.tableName);
        this.setPrimaryKey(primaryKeyRs, columnDefinitions);
        ResultSet importedKeyRs = this.connection.getMetaData().getImportedKeys(null, null, this.tableName);
        this.setForeignKey(importedKeyRs, columnDefinitions);
        return columnDefinitions;
    }

    private void setPrimaryKey(ResultSet rs, List<ColumnDefinition> columnDefinitions) throws SQLException {
        while (rs.next()) {
            String primaryKey = this.getPrimaryKey(rs);
            for (ColumnDefinition columnDefinition : columnDefinitions) {
                if (columnDefinition.getColumnName().equals(primaryKey)) {
                    columnDefinition.setPrimaryKey(true);
                    continue;
                }
                columnDefinition.setPrimaryKey(false);
            }
        }
    }

    private void setForeignKey(ResultSet rs, List<ColumnDefinition> columnDefinitions) throws SQLException {
        while (rs.next()) {
            String foreignKey = this.getForeignKey(rs);
            for (ColumnDefinition columnDefinition : columnDefinitions) {
                if (columnDefinition.getColumnName().equals(foreignKey)) {
                    columnDefinition.setPrimaryKey(true);
                    continue;
                }
                columnDefinition.setPrimaryKey(false);
            }
        }
    }
}

