/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MutexExecutor {
    private Lock lock;

    public MutexExecutor() {
        this.lock = new ReentrantLock();
    }

    public MutexExecutor(Lock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Callable<T> getLockCallback, Callable<T> failLockCallback) throws Exception {
        if (!this.lock.tryLock()) {
            return failLockCallback.call();
        }
        try {
            T t = getLockCallback.call();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void execute(Runnable getLockCallback, Runnable failLockCallback) {
        if (!this.lock.tryLock()) {
            failLockCallback.run();
            return;
        }
        try {
            getLockCallback.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

