/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons.support.tree;

import cn.chenzw.toolkit.commons.support.tree.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TreeBuilder<T, I> {
    private Collection<T> list;
    private Function<T, I> idCallbackFn;
    private Function<T, I> parentIdCallbackFn;
    private Function<T, String> labelCallbackFn;
    private Function<T, Object> extCallbackFn;
    private I startIdValue;

    public static <T, I> TreeBuilder<T, I> create(Collection<T> list) {
        return new TreeBuilder<T, I>(list);
    }

    public TreeBuilder(Collection<T> list) {
        this.list = list;
    }

    public TreeBuilder<T, I> configIdField(Function<T, I> idCallbackFn) {
        this.idCallbackFn = idCallbackFn;
        return this;
    }

    public TreeBuilder<T, I> configParentIdField(Function<T, I> parentIdCallbackFn) {
        this.parentIdCallbackFn = parentIdCallbackFn;
        return this;
    }

    public TreeBuilder<T, I> configLabelField(Function<T, String> labelCallbackFn) {
        this.labelCallbackFn = labelCallbackFn;
        return this;
    }

    public TreeBuilder<T, I> configExtField(Function<T, Object> extCallbackFn) {
        this.extCallbackFn = extCallbackFn;
        return this;
    }

    public TreeBuilder<T, I> startWith(I id) {
        this.startIdValue = id;
        return this;
    }

    public List<TreeNode> build() {
        if (this.idCallbackFn == null) {
            throw new NullPointerException("Missing \"idField\" config!");
        }
        if (this.parentIdCallbackFn == null) {
            throw new NullPointerException("Missing \"parentId\" config!");
        }
        if (this.startIdValue == null) {
            throw new NullPointerException("Missing \"startWith\" config!");
        }
        if (this.labelCallbackFn == null) {
            throw new NullPointerException("Missing \"label\" field config!");
        }
        return this.findChilds(this.startIdValue);
    }

    private List<TreeNode> findChilds(I id) {
        ArrayList<TreeNode> childNode = new ArrayList<TreeNode>();
        for (T item : this.list) {
            I _parentId = this.parentIdCallbackFn.apply(item);
            if (!Objects.equals(id, _parentId)) continue;
            TreeNode<I> treeNode = new TreeNode<I>();
            treeNode.setParentId(_parentId);
            treeNode.setLabel(this.labelCallbackFn.apply(item));
            I _id = this.idCallbackFn.apply(item);
            treeNode.setId(_id);
            treeNode.setChildrens(this.findChilds(_id));
            if (this.extCallbackFn != null) {
                treeNode.setExt(this.extCallbackFn.apply(item));
            }
            treeNode.setLeaf(treeNode.getChildrens().isEmpty());
            childNode.add(treeNode);
        }
        return childNode;
    }
}

