/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static void toZip(File srcDirectory, OutputStream outputStream) {
        long t1 = System.currentTimeMillis();
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            ZipUtils.doCompress(srcDirectory, zos, srcDirectory.getName());
            long t2 = System.currentTimeMillis();
            logger.debug("Finish zip [{}], cost {} ms", (Object)srcDirectory.getPath(), (Object)(t2 - t1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toZip(List<File> srcFiles, OutputStream outputStream) {
        try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
            for (File srcFile : srcFiles) {
                byte[] buff = new byte[1024];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                Throwable throwable = null;
                try {
                    int len;
                    while ((len = in.read(buff)) != -1) {
                        zos.write(buff, 0, len);
                    }
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void doCompress(File srcFile, ZipOutputStream zos, String name) throws IOException {
        byte[] buff = new byte[1024];
        if (srcFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream fis = new FileInputStream(srcFile);){
                int len;
                while ((len = fis.read(buff)) != -1) {
                    zos.write(buff, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] files = srcFile.listFiles();
            if (files == null || files.length == 0) {
                zos.putNextEntry(new ZipEntry(name + File.separator));
                zos.closeEntry();
            } else {
                for (File file : files) {
                    ZipUtils.doCompress(file, zos, name + File.separator + file.getName());
                }
            }
        }
    }
}

