/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UriExtUtils {
    private UriExtUtils() {
    }

    public static String buildParams(String uri, Map<String, String> params) {
        if (StringUtils.isBlank(uri)) {
            return "";
        }
        uri = uri.trim();
        if (params == null || params.size() == 0) {
            return uri.trim();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> map : params.entrySet()) {
            list.add(map.getKey() + "=" + map.getValue());
        }
        String sParam = StringUtils.join(list, "&");
        int index = uri.indexOf(63);
        if (index > -1) {
            if (index == uri.length() - 1) {
                return uri + sParam;
            }
            return uri + "&" + sParam;
        }
        return uri + "?" + sParam;
    }

    public static Map<String, String> getUriParams(String uri) {
        if (StringUtils.isBlank(uri)) {
            return Collections.emptyMap();
        }
        String[] aUri = (uri = uri.trim()).split("\\?");
        if (aUri.length > 1) {
            return UriExtUtils.parseUriParams(aUri[1]);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> parseUriParams(String paramString) {
        if (StringUtils.isBlank(paramString)) {
            return Collections.emptyMap();
        }
        paramString = paramString.trim();
        String[] paramPairs = paramString.split("&");
        HashMap<String, String> retParamMap = new HashMap<String, String>();
        for (String paramPair : paramPairs) {
            String[] param = paramPair.split("=");
            if (param.length > 1) {
                retParamMap.put(param[0], param[1]);
                continue;
            }
            retParamMap.put(param[0], "");
        }
        return retParamMap;
    }
}

