/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import org.apache.commons.lang3.StringUtils;

public abstract class StringExtUtils {
    private static final int INDEX_NOT_FOUND = -1;

    private StringExtUtils() {
    }

    public static String uppercaseSeparate(String name, String separator) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append(separator);
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String toUnderscore(String name) {
        return StringExtUtils.uppercaseSeparate(name, "_");
    }

    public static String toCamel(String name, String separator, boolean firstLetterCapitalized) {
        String[] camels;
        if (name == null || name.length() == 0) {
            return name;
        }
        if (!name.contains(separator)) {
            if (firstLetterCapitalized) {
                return name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            return name;
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = name.split(separator)) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamel(String name) {
        return StringExtUtils.toCamel(name, "_", false);
    }

    public static String toPascal(String name, String separator) {
        String camelName = StringExtUtils.toCamel(name, separator, true);
        if (StringUtils.isEmpty(camelName)) {
            return "";
        }
        return camelName.substring(0, 1).toUpperCase() + camelName.substring(1);
    }

    public static String toPascal(String name) {
        return StringExtUtils.toPascal(name, "_");
    }

    public static String subStringFirstAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(pos + separator.length());
    }

    public static String subStringFirstBefore(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static Integer toInteger(String str, Integer defaultValue) {
        if (StringUtils.isEmpty(StringUtils.trim(str))) {
            return defaultValue;
        }
        if (StringUtils.contains((CharSequence)str, ".")) {
            return Double.valueOf(str).intValue();
        }
        return Integer.valueOf(str);
    }

    public static Integer toInteger(String str) {
        return StringExtUtils.toInteger(str, null);
    }

    public static Long toLong(String str, Long defaultValue) {
        if (StringUtils.isEmpty(StringUtils.trim(str))) {
            return defaultValue;
        }
        return Long.valueOf(str);
    }

    public static Long toLong(String str) {
        return StringExtUtils.toLong(str, null);
    }

    public static Float toFloat(String str, Float defaultValue) {
        if (StringUtils.isEmpty(StringUtils.trim(str))) {
            return defaultValue;
        }
        return Float.valueOf(str);
    }

    public static Float toFloat(String str) {
        return StringExtUtils.toFloat(str, null);
    }

    public static Double toDouble(String str, Double defaultValue) {
        if (StringUtils.isEmpty(StringUtils.trim(str))) {
            return defaultValue;
        }
        return Double.valueOf(str);
    }

    public static Double toDouble(String str) {
        return StringExtUtils.toDouble(str, null);
    }

    public static int hasAsciiAlphas(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            ++count;
        }
        return count;
    }

    public static int hasCapitalizedAsciiAlphas(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < 'A' || ch > 'Z') continue;
            ++count;
        }
        return count;
    }

    public static int hasLowercaseAsciiAlphas(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < 'a' || ch > 'z') continue;
            ++count;
        }
        return count;
    }

    public static int hasDigit(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    public static boolean containsAsciiAlpha(String str) {
        return StringExtUtils.hasAsciiAlphas(str) > 0;
    }

    public static boolean containsCapitalizedAsciiAlpha(String str) {
        return StringExtUtils.hasCapitalizedAsciiAlphas(str) > 0;
    }

    public static boolean containsLowercaseAsciiAlphas(String str) {
        return StringExtUtils.hasLowercaseAsciiAlphas(str) > 0;
    }

    public static boolean containsDigit(String str) {
        return StringExtUtils.hasDigit(str) > 0;
    }
}

