/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RuntimeExtUtils {
    public static String execForStr(String ... cmds) throws IOException {
        Charset charset = Charset.defaultCharset();
        if (SystemUtils.IS_OS_WINDOWS) {
            charset = Charset.forName("GBK");
        }
        return RuntimeExtUtils.execForStr(charset, cmds);
    }

    public static String execForStr(Charset charset, String ... cmds) throws IOException {
        return RuntimeExtUtils.getStringProcessResult(RuntimeExtUtils.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws IOException {
        Charset charset = Charset.defaultCharset();
        if (SystemUtils.IS_OS_WINDOWS) {
            charset = Charset.forName("GBK");
        }
        return RuntimeExtUtils.execForLines(charset, cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws IOException {
        return RuntimeExtUtils.getLinesProcessResult(RuntimeExtUtils.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) throws IOException {
        cmds = RuntimeExtUtils.doInitCmdArgs(cmds);
        return new ProcessBuilder(cmds).redirectErrorStream(true).start();
    }

    public static Process exec(String[] envp, String ... cmds) throws IOException {
        cmds = RuntimeExtUtils.doInitCmdArgs(cmds);
        return Runtime.getRuntime().exec(cmds, envp);
    }

    private static String[] doInitCmdArgs(String ... cmds) {
        if (ArrayUtils.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty!");
        }
        if (cmds.length == 1) {
            cmds = StringUtils.split(cmds[0]);
        }
        return cmds;
    }

    /*
     * Loose catch block
     */
    public static String getStringProcessResult(Process process, Charset charset) throws IOException {
        try {
            try (InputStream in = process.getInputStream();){
                String string = IOUtils.toString((InputStream)in, (Charset)charset);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static List<String> getLinesProcessResult(Process process, Charset charset) throws IOException {
        try {
            try (InputStream in = process.getInputStream();){
                List list = IOUtils.readLines((InputStream)in, (Charset)charset);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

