/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class RegexUtils {
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");

    private RegexUtils() {
    }

    public static boolean isIPv4(String ipv4) {
        return Pattern.matches("\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", ipv4);
    }

    public static boolean isIPv6(String ipv6) {
        return Pattern.matches("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))", ipv6);
    }

    public static boolean isIp(String ip) {
        return RegexUtils.isIPv4(ip) || RegexUtils.isIPv6(ip);
    }

    public static final boolean isEmail(String email) {
        return Pattern.matches("^\\w+@(\\w+\\.){1,2}\\w+$", email);
    }

    public static boolean isQQ(String qq) {
        return Pattern.matches("^[1-9][0-9]{4,}$", qq);
    }

    public static boolean isIdCard(String idCard) {
        if (StringUtils.isBlank(idCard)) {
            throw new IllegalArgumentException("Parameter \"idCard\" must be not null");
        }
        if (idCard.length() == 15) {
            return Pattern.matches("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", idCard);
        }
        if (idCard.length() == 18) {
            return Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|X)$", idCard);
        }
        return false;
    }

    public static boolean containsChinese(String chinese) {
        return CHINESE_PATTERN.matcher(chinese).find();
    }

    public static boolean isChinese(String chinese) {
        return Pattern.matches("^[\\u4e00-\\u9fa5]{0,}$", chinese);
    }

    public static boolean isPhoneNO(String phoneNo) {
        return Pattern.matches("^(13[0-9]|14[579]|15([0-5]|[6-9])|16[6]|17([013]|[5-8])|18([0-3]|[5-9])|19[89])\\d{8}$", phoneNo);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String number) {
        try {
            Double.parseDouble(number);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isLooseMobile(String mobile) {
        return Pattern.matches("(?:0|86|\\+86)?1[3456789]\\d{9}", mobile);
    }

    public static int hasSpecialCharacters(String str) {
        int count = 0;
        Pattern pattern = Pattern.compile("[ _`~!@#$%^&*()+\\-=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean containsSpecialCharacter(String str) {
        return RegexUtils.hasSpecialCharacters(str) > 0;
    }
}

