/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import cn.chenzw.toolkit.commons.ClassExtUtils;
import cn.chenzw.toolkit.commons.ConvertExtUtils;
import cn.chenzw.toolkit.commons.exception.FieldNotExistException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ReflectExtUtils {
    private static final Map<Class<?>, Field[]> FIELDS_CACHE = new WeakHashMap();
    private static final Map<Class<?>, Method[]> METHODS_CACHE = new WeakHashMap();

    public static void setFieldValue(Object o, String fieldName, Object value) throws IllegalAccessException, FieldNotExistException {
        Objects.requireNonNull(o, "object is null");
        Objects.requireNonNull(fieldName, "fieldName is null.");
        Class<?> aClass = o.getClass();
        Field field = ReflectExtUtils.getField(aClass, fieldName);
        if (field == null) {
            throw new FieldNotExistException(fieldName, o);
        }
        ReflectExtUtils.setFieldValue(o, field, value);
    }

    public static void setFieldValueQuietly(Object o, String fieldName, Object value) throws IllegalAccessException {
        Objects.requireNonNull(o, "object must not be null.");
        Objects.requireNonNull(fieldName, "fieldName must not be null.");
        Class<?> aClass = o.getClass();
        Field field = ReflectExtUtils.getField(aClass, fieldName);
        if (field == null) {
            return;
        }
        ReflectExtUtils.setFieldValue(o, field, value);
    }

    public static void setStaticFinalFieldValue(Object o, String fieldName, Object value) throws NoSuchFieldException, FieldNotExistException, IllegalAccessException {
        Objects.requireNonNull(o, "object must not be null.");
        Objects.requireNonNull(fieldName, "fieldName must not be null.");
        Class<?> aClass = o.getClass();
        Field field = ReflectExtUtils.getField(aClass, fieldName);
        if (field == null) {
            throw new FieldNotExistException(fieldName, o);
        }
        ReflectExtUtils.setStaticFinalFieldValue(field, value);
    }

    public static void setStaticFinalFieldValue(Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectExtUtils.setAccessible(field);
        ReflectExtUtils.setFinalAccessible(field);
        field.set(null, ReflectExtUtils.tryConvert(field, value));
    }

    public static void setFinalAccessible(Field field) throws NoSuchFieldException, IllegalAccessException {
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    public static void setFieldValue(Object o, Field field, Object value) throws IllegalAccessException {
        ReflectExtUtils.setAccessible(field);
        field.set(o, ReflectExtUtils.tryConvert(field, value));
    }

    private static Object tryConvert(Field field, Object value) {
        Object targetValue;
        Class<?> fieldType;
        if (value != null && !(fieldType = field.getType()).isAssignableFrom(value.getClass()) && (targetValue = ConvertExtUtils.convert(fieldType, value)) != null) {
            return targetValue;
        }
        return value;
    }

    public static Object getFieldValue(Object o, Field field) throws IllegalAccessException {
        Objects.requireNonNull(o, "object must not be null");
        Objects.requireNonNull(field, "field must not be null.");
        ReflectExtUtils.setAccessible(field);
        return field.get(o);
    }

    public static Object getFieldValue(Object o, String fieldName) throws IllegalAccessException, FieldNotExistException {
        Objects.requireNonNull(o, "object must not be null");
        Objects.requireNonNull(fieldName, "fieldName must not be null.");
        Field field = ReflectExtUtils.getField(o.getClass(), fieldName);
        if (field == null) {
            throw new FieldNotExistException(fieldName, o);
        }
        return ReflectExtUtils.getFieldValue(o, field);
    }

    public static Object getFieldValueQuietly(Object o, String fieldName) throws IllegalAccessException {
        Objects.requireNonNull(o, "object must not be null");
        Objects.requireNonNull(fieldName, "fieldName must not be null.");
        Field field = ReflectExtUtils.getField(o.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        return ReflectExtUtils.getFieldValue(o, field);
    }

    public static Field[] getFields(Class<?> aClass) {
        if (FIELDS_CACHE.containsKey(aClass)) {
            return FIELDS_CACHE.get(aClass);
        }
        Field[] declaredFields = aClass.getDeclaredFields();
        for (Class<?> superClass = aClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Field[] superClassFileds = superClass.getDeclaredFields();
            declaredFields = ArrayUtils.addAll(declaredFields, superClassFileds);
        }
        FIELDS_CACHE.put(aClass, declaredFields);
        return declaredFields;
    }

    public static Field getField(Class<?> aClass, String fieldName) {
        Field[] fields = ReflectExtUtils.getFields(aClass);
        if (ArrayUtils.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static Method[] getMethods(Class<?> aClass) {
        if (METHODS_CACHE.containsKey(aClass)) {
            return METHODS_CACHE.get(aClass);
        }
        Method[] declaredMethods = aClass.getDeclaredMethods();
        for (Class<?> superClass = aClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            Method[] superClassMethods = superClass.getDeclaredMethods();
            declaredMethods = ArrayUtils.addAll(declaredMethods, superClassMethods);
        }
        METHODS_CACHE.put(aClass, declaredMethods);
        return declaredMethods;
    }

    public static Method getMethod(Object o, String methodName, Object ... args) {
        Method[] methods = ReflectExtUtils.getMethods(o.getClass());
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramTypes[i] = args[i] == null ? Object.class : args[i].getClass();
        }
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                if (!StringUtils.contains((CharSequence)method.getName(), methodName) || !ClassExtUtils.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static <T> T invoke(Object o, String methodName, Object ... args) throws InvocationTargetException, IllegalAccessException {
        Objects.requireNonNull(o, "object must not be null!");
        if (StringUtils.isEmpty(methodName)) {
            throw new IllegalArgumentException("methodName must not be null!");
        }
        Method method = ReflectExtUtils.getMethod(o, methodName, args);
        Objects.requireNonNull(method, "No such method: [ " + methodName + " ]!");
        ReflectExtUtils.setAccessible(method);
        if (ClassExtUtils.isStatic(method)) {
            return (T)method.invoke(null, args);
        }
        return (T)method.invoke(o, args);
    }
}

