/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import cn.chenzw.toolkit.commons.ArrayExtUtils;
import cn.chenzw.toolkit.commons.ReflectExtUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class ObjectExtUtils {
    public static int identityHashCode(Object o) {
        return System.identityHashCode(o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T clone(T o) {
        T result = ArrayExtUtils.clone(o);
        if (result != null) return result;
        if (o instanceof Cloneable) {
            try {
                ReflectExtUtils.invoke(o, "clone", new Object[0]);
                return result;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return result;
            }
        }
        if (!(o instanceof Serializable)) return result;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteOut);){
            out.writeObject(o);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            Object object = in.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }
}

