/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ListExtUtils {
    private ListExtUtils() {
    }

    public static final <T> String joinFieldValue(List<T> list, String fieldName, String separatorChars) throws NoSuchFieldException, IllegalAccessException {
        ArrayList<String> fieldValues = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            Field field = list.get(0).getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            for (T item : list) {
                fieldValues.add(String.valueOf(field.get(item)));
            }
            return StringUtils.join((Object[])fieldValues.toArray(new String[fieldValues.size()]), separatorChars);
        }
        return "";
    }

    public static final <T> String joinFieldValue(List<T> list, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ListExtUtils.joinFieldValue(list, fieldName, ",");
    }

    public static final <T> boolean contains(List<T> list, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        if (list != null && !list.isEmpty()) {
            Field field = list.get(0).getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            for (T item : list) {
                if (!Objects.equals(field.get(item), value)) continue;
                return true;
            }
        }
        return false;
    }

    public static final <T> boolean contains(List<T> list, Map<String, Object> kvMap) throws NoSuchFieldException, IllegalAccessException {
        if (list != null && !list.isEmpty()) {
            Map<Field, Object> fvMap = ListExtUtils.getFieldMap(list, kvMap);
            for (T item : list) {
                if (!ListExtUtils.contains(fvMap, item)) continue;
                return true;
            }
        }
        return false;
    }

    public static final <T> List<T> find(List<T> list, Map<String, Object> kvMap) throws NoSuchFieldException, IllegalAccessException {
        ArrayList<T> finded = new ArrayList<T>();
        if (list != null && !list.isEmpty()) {
            Map<Field, Object> fvMap = ListExtUtils.getFieldMap(list, kvMap);
            for (T item : list) {
                if (!ListExtUtils.contains(fvMap, item)) continue;
                finded.add(item);
            }
        }
        return finded;
    }

    public static final <T> T findFirst(List<T> list, Map<String, Object> kvMap) throws NoSuchFieldException, IllegalAccessException {
        List<T> rets = ListExtUtils.find(list, kvMap);
        if (!rets.isEmpty()) {
            return rets.get(0);
        }
        return null;
    }

    public static final <T, T1, T2> List<T> subtract(Collection<T1> listA, Collection<T2> listB, BiFunction<T1, T2, Boolean> matchFunction) {
        Objects.requireNonNull(listA, "listA must not be null!");
        Objects.requireNonNull(listB, "listB must not be null!");
        return listA.stream().filter(item -> listB.stream().allMatch(item2 -> (Boolean)matchFunction.apply(item, item2) == false)).collect(Collectors.toList());
    }

    public static final <T> List<T> intersection(Collection<T> listA, Collection<T> listB, BiFunction<T, T, Boolean> matchFunction) {
        Objects.requireNonNull(listA, "listA must not be null!");
        Objects.requireNonNull(listB, "listB must not be null!");
        return listA.stream().filter(item -> listB.stream().anyMatch(item2 -> (Boolean)matchFunction.apply(item, item2))).collect(Collectors.toList());
    }

    public static final <T, U extends Comparable<? super U>> List<T> unique(Collection<T> list, Function<T, U> matchFunction) {
        Objects.requireNonNull(list);
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(Comparator.comparing(matchFunction))), ArrayList::new));
    }

    private static final <T> Map<Field, Object> getFieldMap(List<T> list, Map<String, Object> kvMap) throws NoSuchFieldException {
        HashMap<Field, Object> fvMap = new HashMap<Field, Object>();
        for (Map.Entry<String, Object> kvEntity : kvMap.entrySet()) {
            Field field = list.get(0).getClass().getDeclaredField(kvEntity.getKey());
            field.setAccessible(true);
            fvMap.put(field, kvEntity.getValue());
        }
        return fvMap;
    }

    private static <T> boolean contains(Map<Field, Object> fvMap, T item) throws IllegalAccessException {
        for (Map.Entry<Field, Object> fvEntity : fvMap.entrySet()) {
            if (Objects.equals(fvEntity.getKey().get(item), fvEntity.getValue())) continue;
            return false;
        }
        return true;
    }
}

