/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class GenericUtils {
    private GenericUtils() {
    }

    public static final <T> Class getSuperClassGenricType(List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0).getClass();
        }
        return Object.class;
    }

    public static final Class getSuperClassGenricType(Class clazz) {
        return GenericUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }
}

