/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateExtUtils {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final String[] FREQUENTLEY_USED_UTC_WITH_Z_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
    private static final String[] FREQUENTLEY_USED_UTC_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
    private static final String[] FREQUENTLY_USED_NUMBER_DATE_FORMATS = new String[]{"yyyyMMddHHmmss", "yyyyMMddHHmmssSSS", "yyyyMMdd", "yyyyMMss", "HHmmss"};
    private static final String[] FREQUENTLY_USED_CST_DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss zzz yyyy"};
    private static final String[] FREQUENTLY_USED_DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "HH:mm:ss", "HH\u65f6mm\u5206ss\u79d2", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss.SSS"};

    private DateExtUtils() {
    }

    public static final Date random(Date startDateInclusive, Date endDateExclusive) {
        int betweenSeconds = (int)((endDateExclusive.getTime() - startDateInclusive.getTime()) / 1000L);
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDateInclusive);
        instance.add(13, RandomUtils.nextInt(0, betweenSeconds));
        return instance.getTime();
    }

    public static final Date random() {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(0L);
        instance.add(12, RandomUtils.nextInt(0, Integer.MAX_VALUE));
        return instance.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        DateExtUtils.eraseTime(calendar);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(String month, String format) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDate(month, format));
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        DateExtUtils.eraseTime(calendar);
        return calendar.getTime();
    }

    public static Date getYesterday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getYesterday() {
        return DateExtUtils.getYesterday(Calendar.getInstance().getTime());
    }

    public static Date getLastDayOfMonth(String month, String format) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDate(month, format));
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isDayBetween(Date date, Date startDateInclusive, Date endDateInclusive) {
        if (date == null) {
            return false;
        }
        return date.after(startDateInclusive) && date.before(endDateInclusive) || date.equals(startDateInclusive) || date.equals(endDateInclusive);
    }

    public static Date parseDate(String dateTimeStr) throws ParseException {
        if (StringUtils.isEmpty(dateTimeStr)) {
            throw new IllegalArgumentException("Date string must not be null");
        }
        String[] dateFormats = NumberUtils.isCreatable(dateTimeStr) ? FREQUENTLY_USED_NUMBER_DATE_FORMATS : (StringUtils.contains((CharSequence)dateTimeStr, 84) ? (StringUtils.contains((CharSequence)dateTimeStr, 90) ? FREQUENTLEY_USED_UTC_WITH_Z_DATE_FORMATS : FREQUENTLEY_USED_UTC_DATE_FORMATS) : (StringUtils.containsAny((CharSequence)dateTimeStr, wtb) ? FREQUENTLY_USED_CST_DATE_FORMATS : FREQUENTLY_USED_DATE_FORMATS));
        return DateUtils.parseDate(dateTimeStr, dateFormats);
    }

    public static Instant toInstant(Date date) {
        return date == null ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }

    public static Date eraseTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateExtUtils.eraseTime(calendar);
        return calendar.getTime();
    }

    public static Date eraseTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

