/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import cn.chenzw.toolkit.commons.support.convert.TypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.AtomicIntegerTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.AtomicLongTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.BigDecimalTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.BigIntegerTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.DateTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.NumberTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.StringTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.BooleanPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.BytePrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.CharPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.DoublePrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.FloatPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.IntegerPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.LongPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.primitive.ShortPrimitiveTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.BooleanWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.ByteWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.DoubleWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.FloatWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.IntegerWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.LongWrapperTypeConverter;
import cn.chenzw.toolkit.commons.support.convert.impl.wrapper.ShortWrapperTypeConverter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConvertExtUtils {
    private static Map<Type, TypeConverter<?>> defaultTypeConverterMap = new HashMap();

    private ConvertExtUtils() {
    }

    public static <T> T convert(Class<T> type, Object value) {
        return ConvertExtUtils.convert(type, value);
    }

    public static <T> T convert(Type type, Object value) {
        return ConvertExtUtils.getConverter(type).convert(value, null);
    }

    private static <T> TypeConverter<T> getConverter(Type type) {
        TypeConverter<?> typeConverter = defaultTypeConverterMap.get(type);
        if (typeConverter != null) {
            return typeConverter;
        }
        throw new UnsupportedOperationException("No Converter for type [" + type.getTypeName() + "]");
    }

    static {
        defaultTypeConverterMap.put(Integer.TYPE, new IntegerPrimitiveTypeConverter());
        defaultTypeConverterMap.put(Long.TYPE, new LongPrimitiveTypeConverter());
        defaultTypeConverterMap.put(Byte.TYPE, new BytePrimitiveTypeConverter());
        defaultTypeConverterMap.put(Short.TYPE, new ShortPrimitiveTypeConverter());
        defaultTypeConverterMap.put(Float.TYPE, new FloatPrimitiveTypeConverter());
        defaultTypeConverterMap.put(Double.TYPE, new DoublePrimitiveTypeConverter());
        defaultTypeConverterMap.put(Character.TYPE, new CharPrimitiveTypeConverter());
        defaultTypeConverterMap.put(Boolean.TYPE, new BooleanPrimitiveTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Integer.class), new IntegerWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Long.class), new LongWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Byte.class), new ByteWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Short.class), new ShortWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Float.class), new FloatWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Double.class), new DoubleWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Boolean.class), new BooleanWrapperTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Character.class), new CharPrimitiveTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Date.class), new DateTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)String.class), new StringTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)AtomicInteger.class), new AtomicIntegerTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)AtomicLong.class), new AtomicLongTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)BigDecimal.class), new BigDecimalTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)BigInteger.class), new BigIntegerTypeConverter());
        defaultTypeConverterMap.put((Type)((Object)Number.class), new NumberTypeConverter());
    }
}

