/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.awt.Color;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static final Color hexToRgb(String hexColor) {
        if (StringUtils.isBlank(hexColor)) {
            throw new IllegalArgumentException("hex color is null!");
        }
        if (StringUtils.startsWith(hexColor, "#")) {
            hexColor = StringUtils.removeStart(hexColor, "#");
        }
        return new Color(Integer.parseInt(hexColor, 16));
    }

    public static final Color randomColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

