/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ClassExtUtils {
    private ClassExtUtils() {
    }

    public static boolean isPresent(String className) {
        return ClassExtUtils.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassExtUtils.forName(className, classLoader);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassExtUtils.forName(name, null);
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ClassExtUtils.getDefaultClassLoader();
        }
        return classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cl == null && (cl = ClassExtUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return cl;
    }

    public static URL findSourceJar(Class cls) {
        ProtectionDomain protectionDomain = cls.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }

    public static String generateUniqueClassName(String className) {
        String originalName = className;
        int i = 1;
        while (ClassExtUtils.isPresent(className)) {
            className = originalName + "$" + i++;
        }
        return className;
    }

    public static boolean isAllAssignableFrom(Class<?>[] fatherTypes, Class<?>[] childTypes) {
        if (ArrayUtils.isEmpty(fatherTypes) && ArrayUtils.isEmpty(childTypes)) {
            return true;
        }
        if (fatherTypes == null || childTypes == null) {
            return false;
        }
        if (fatherTypes.length != childTypes.length) {
            return false;
        }
        for (int i = 0; i < fatherTypes.length; ++i) {
            if (fatherTypes[i].isAssignableFrom(childTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isStatic(Method method) {
        Objects.requireNonNull(method, "Method to provided is null!");
        return Modifier.isStatic(method.getModifiers());
    }
}

