/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayExtUtils {
    public static <T> List<T[]> split(T[] data, int segmentLen) {
        ArrayList<T[]> result = new ArrayList<T[]>();
        int dataSize = data.length;
        if (dataSize < segmentLen) {
            result.add(data);
        } else {
            int segmentCount = dataSize / segmentLen;
            segmentCount = dataSize % segmentLen == 0 ? segmentCount : segmentCount + 1;
            for (int i = 0; i < segmentCount; ++i) {
                if (i == segmentCount - 1) {
                    result.add(Arrays.copyOfRange(data, segmentLen * i, dataSize));
                    continue;
                }
                result.add(Arrays.copyOfRange(data, segmentLen * i, segmentLen * (i + 1)));
            }
        }
        return result;
    }

    public static <T> T clone(T o) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            Object result;
            Class<?> componentType = o.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(o);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(o, length));
                }
            } else {
                result = ((Object[])o).clone();
            }
            return (T)result;
        }
        return null;
    }
}

