/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.codec;

import cn.chenzw.toolkit.codec.support.aes.AESKeyMeta;
import cn.chenzw.toolkit.codec.support.aes.AESMode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public abstract class AESUtils {
    private static final String AES_ALGORITHM = "AES";

    private AESUtils() {
    }

    public static byte[] deigest(int mode, byte[] data, String key, AESMode aesMode, AESKeyMeta aesKeyMeta, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (data == null) {
            throw new IllegalArgumentException("Parameter \"data\" must not be null");
        }
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("Parameter \"key\" must not be null");
        }
        if (aesMode == null) {
            throw new IllegalArgumentException("Parameter \"aesMod\" must not be null");
        }
        if (aesKeyMeta == null) {
            throw new IllegalArgumentException("Parameter \"aesKeyMeta\" must not be null");
        }
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(key.getBytes());
        KeyGenerator kgen = KeyGenerator.getInstance(AES_ALGORITHM);
        kgen.init(aesKeyMeta.getBitLen(), random);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(aesMode.getModeAndPadding());
        if (iv != null) {
            cipher.init(mode, (Key)keySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(mode, keySpec);
        }
        return cipher.doFinal(data);
    }

    public static String encryptAsHexString(String data, String key, AESMode aesMode, AESKeyMeta aesKeyMeta, byte[] iv) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] bytes = AESUtils.deigest(1, data.getBytes(), key, aesMode, aesKeyMeta, iv);
        return Hex.encodeHexString(bytes);
    }

    public static String encryptAsHexString(String data, String key) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return AESUtils.encryptAsHexString(data, key, AESMode.AES_DEFAULT, AESKeyMeta.BIT_256, null);
    }

    public static byte[] decryptHexString(String hexString, String key, AESMode aesMode, AESKeyMeta aesKeyMeta, byte[] iv) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, DecoderException {
        return AESUtils.deigest(2, Hex.decodeHex((String)hexString), key, aesMode, aesKeyMeta, iv);
    }

    public static byte[] decryptHexString(String hexString, String key) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, DecoderException {
        return AESUtils.decryptHexString(hexString, key, AESMode.AES_DEFAULT, AESKeyMeta.BIT_256, null);
    }

    public static String encryptAsBase64String(String data, String key, AESMode aesMode, AESKeyMeta aesKeyMeta, byte[] iv) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] bytes = AESUtils.deigest(1, data.getBytes(), key, aesMode, aesKeyMeta, iv);
        return Base64.encodeBase64String(bytes);
    }

    public static String encryptAsBase64String(String data, String key) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        return AESUtils.encryptAsBase64String(data, key, AESMode.AES_DEFAULT, AESKeyMeta.BIT_256, null);
    }

    public static byte[] decryptBase64String(String base64String, String key, AESMode aesMode, AESKeyMeta aesKeyMeta, byte[] iv) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return AESUtils.deigest(2, Base64.decodeBase64(base64String), key, aesMode, aesKeyMeta, iv);
    }

    public static byte[] decryptBase64String(String base64String, String key) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        return AESUtils.decryptBase64String(base64String, key, AESMode.AES_DEFAULT, AESKeyMeta.BIT_256, null);
    }
}

