/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.cache;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheUtils {
    private static CacheManager cacheManager;

    private EhCacheUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getCacheManager() {
        if (cacheManager != null) return cacheManager;
        Class<EhCacheUtils> clazz = EhCacheUtils.class;
        synchronized (EhCacheUtils.class) {
            if (cacheManager != null) return cacheManager;
            cacheManager = CacheManager.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheManager;
        }
    }

    public static Cache getCache(String cacheName) {
        CacheManager cacheManager = EhCacheUtils.getCacheManager();
        return cacheManager.getCache(cacheName);
    }

    public static List<Cache> getCaches() {
        String[] cacheNames;
        ArrayList<Cache> caches = new ArrayList<Cache>();
        CacheManager cacheManager = EhCacheUtils.getCacheManager();
        for (String cacheName : cacheNames = cacheManager.getCacheNames()) {
            caches.add(cacheManager.getCache(cacheName));
        }
        return caches;
    }

    public static List getKeys(String cacheName) {
        return EhCacheUtils.getCache(cacheName).getKeys();
    }

    public static <T> T getValue(String cacheName, Object key) {
        Element element = EhCacheUtils.getCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static List<Element> getElements(String cacheName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Cache cache = EhCacheUtils.getCache(cacheName);
        List keys = cache.getKeys();
        for (Object key : keys) {
            elements.add(cache.get(key));
        }
        return elements;
    }

    public static List<Element> getElements() {
        String[] cacheNames;
        ArrayList<Element> elements = new ArrayList<Element>();
        for (String cacheName : cacheNames = EhCacheUtils.getCacheManager().getCacheNames()) {
            elements.addAll(EhCacheUtils.getElements(cacheName));
        }
        return elements;
    }

    public static void addCache(String cacheName) {
        CacheManager cacheManager = EhCacheUtils.getCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cacheManager.addCacheIfAbsent(cacheName);
        }
    }

    public static void addElement(String cacheName, Object key, Object value) {
        EhCacheUtils.getCache(cacheName).put(new Element(key, value));
    }

    public static boolean removeKey(String cacheName, Object key) {
        Cache cache = EhCacheUtils.getCache(cacheName);
        if (cache != null) {
            return cache.remove(key);
        }
        return false;
    }

    public static void removeAllKeys(String cacheName) {
        Cache cache = EhCacheUtils.getCache(cacheName);
        if (cache != null) {
            cache.removeAll();
        }
    }
}

