/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.authentication.support;

import cn.chenzw.toolkit.commons.ColorUtils;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class CaptchaBuilder {
    private int width = 120;
    private int height = 62;
    private Font[] fonts;
    private String[] fontNames = new String[]{"Times New Roman"};
    private String text;
    private boolean enableDrawRandomLine = true;
    private int fontSize = 32;

    public CaptchaBuilder width(int width) {
        this.width = width;
        return this;
    }

    public CaptchaBuilder height(int height) {
        this.height = height;
        return this;
    }

    public CaptchaBuilder fonts(Font[] fonts) {
        this.fonts = fonts;
        return this;
    }

    public CaptchaBuilder fonts(String[] fontNames) {
        this.fontNames = fontNames;
        return this;
    }

    public CaptchaBuilder text(String text) {
        this.text = text;
        return this;
    }

    public CaptchaBuilder enableDrawRandomLine(boolean enableDrawRandomLine) {
        this.enableDrawRandomLine = enableDrawRandomLine;
        return this;
    }

    private void drawRandomLine(Graphics graphics) {
        graphics.setColor(ColorUtils.randomColor(160, 200));
        for (int i = 0; i < 150; ++i) {
            int x = RandomUtils.nextInt(0, this.width);
            int y = RandomUtils.nextInt(0, this.height);
            int xl = RandomUtils.nextInt(0, this.width);
            int yl = RandomUtils.nextInt(0, this.height);
            graphics.drawLine(x, y, x + xl, y + yl);
        }
    }

    private void drawText(Graphics graphics) {
        if (!StringUtils.isEmpty(this.text)) {
            for (int i = 0; i < this.text.length(); ++i) {
                graphics.setColor(ColorUtils.randomColor(20, 130));
                graphics.drawString(String.valueOf(this.text.charAt(i)), this.width / this.text.length() * i + RandomUtils.nextInt(0, 10), this.height / 2 + this.fontSize / 2 - RandomUtils.nextInt(0, 10));
            }
        }
    }

    public BufferedImage build() throws IOException {
        BufferedImage image = new BufferedImage(this.width, this.height, 5);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        graphics.setColor(ColorUtils.randomColor(200, 255));
        graphics.fillRect(0, 0, this.width, this.height);
        if (!ArrayUtils.isEmpty(this.fonts)) {
            Font font = this.fonts[RandomUtils.nextInt(0, this.fonts.length - 1)];
            graphics.setFont(font);
            this.fontSize = font.getSize();
        } else if (!ArrayUtils.isEmpty(this.fontNames)) {
            String fontName = this.fontNames[RandomUtils.nextInt(0, this.fontNames.length - 1)];
            graphics.setFont(new Font(fontName, 2, this.fontSize));
        }
        if (this.enableDrawRandomLine) {
            this.drawRandomLine(graphics);
        }
        this.drawText(graphics);
        graphics.dispose();
        return image;
    }
}

