/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.toolkit.authentication.security;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class SecurityUtils {
    public static <T> T getCurrentUser() {
        Authentication authentication = SecurityUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        return (T)authentication.getPrincipal();
    }

    public static String getCurrentUserIp() {
        Authentication authentication = SecurityUtils.getAuthentication();
        if (authentication == null) {
            return "";
        }
        Object details = authentication.getDetails();
        if (!(details instanceof WebAuthenticationDetails)) {
            return "";
        }
        WebAuthenticationDetails webDetails = (WebAuthenticationDetails)details;
        return webDetails.getRemoteAddress();
    }

    public static boolean hasAnyRole(String ... roles) {
        Authentication authentication = SecurityUtils.getAuthentication();
        if (authentication == null) {
            return false;
        }
        Collection grantedAuthorities = authentication.getAuthorities();
        for (String role : roles) {
            for (GrantedAuthority authority : grantedAuthorities) {
                if (!role.equals(authority.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }

    public static void saveUserDetailsToContext(UserDetails userDetails, HttpServletRequest request) {
        PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities());
        if (request != null) {
            authentication.setDetails((Object)new WebAuthenticationDetails(request));
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    private static Authentication getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            return null;
        }
        return context.getAuthentication();
    }
}

