/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.util;

import cn.chenzw.excel.magic.core.exception.ExcelException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ExcelResponseUtils {
    public static HttpServletResponse getBuiltinResponse(HttpServletResponse response, String fileName) {
        response.setContentType("application/octet-stream");
        if (StringUtils.isBlank(fileName)) {
            fileName = "template.xlsx";
        } else if (!StringUtils.endsWithAny(fileName, ".xlsx", ".xls")) {
            fileName = fileName + ".xlsx";
        }
        try {
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new ExcelException("\u6587\u4ef6\u540d\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"; filename*=utf-8''" + fileName);
        return response;
    }
}

