/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.util;

import cn.chenzw.excel.magic.core.meta.model.ExcelCellDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelRowDefinition;
import cn.chenzw.toolkit.commons.ConvertExtUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelFieldUtils {
    private static final String[] TRY_DATE_FORMAT_LIST = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss"};

    public static void setCellValue(Cell cell, Object o, Field field) throws IllegalAccessException {
        Object value = field.get(o);
        if (value == null) {
            return;
        }
        if (value instanceof Long) {
            cell.setCellValue(((Long)value).longValue());
        } else if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Integer) {
            cell.setCellValue(((Integer)value).intValue());
        } else if (value instanceof Float) {
            cell.setCellValue(((Float)value).floatValue());
        } else if (value instanceof Short) {
            cell.setCellValue(((Short)value).shortValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Double) {
            cell.setCellValue((Double)value);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u6570\u636e\u7c7b\u578b => [" + field.getType() + "]!");
        }
    }

    public static String getCellValue(ExcelRowDefinition row, int colIndex) {
        for (ExcelCellDefinition cell : row.getExcelCells()) {
            if (cell.getColIndex() != colIndex) continue;
            return cell.getCellValue();
        }
        return "";
    }

    public static void setFieldValue(Field field, Object o, Object cellValue, String dateFormat) throws IllegalAccessException {
        if (field.getType() == String.class && !StringUtils.isBlank(dateFormat)) {
            try {
                field.set(o, DateUtils.parseDate((String)cellValue, dateFormat));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        field.set(o, ConvertExtUtils.convert(field.getType(), cellValue));
    }
}

