/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.support.validator;

import cn.chenzw.excel.magic.core.exception.ExcelValidationException;
import cn.chenzw.excel.magic.core.meta.annotation.validation.ExcelRegexValue;
import cn.chenzw.excel.magic.core.support.validator.AbstractExcelColumnValidator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ExcelRegexValidator
implements AbstractExcelColumnValidator<ExcelRegexValue> {
    private Pattern pattern;
    private String message;

    @Override
    public void initialize(ExcelRegexValue excelRegexValue) {
        String regex = excelRegexValue.regex();
        if (StringUtils.isBlank(regex)) {
            throw new IllegalArgumentException("\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a\u7a7a!");
        }
        this.pattern = Pattern.compile(regex);
        this.message = excelRegexValue.message();
    }

    @Override
    public boolean validate(String value) {
        if (StringUtils.isBlank(value)) {
            return true;
        }
        if (this.pattern.matcher(value).matches()) {
            return true;
        }
        if (!StringUtils.isEmpty(this.message)) {
            throw new ExcelValidationException(this.message);
        }
        return false;
    }
}

