/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.support;

import cn.chenzw.excel.magic.core.context.AnnotationExcelWriterContext;
import cn.chenzw.excel.magic.core.context.ExcelWriterContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter {
    private ExcelWriterContext writerContext = new AnnotationExcelWriterContext();

    public static ExcelWriter newInstance() {
        return new ExcelWriter();
    }

    public static ExcelWriter newTemplateInstance(Class<?> ... clazzs) {
        ExcelWriter excelWriter = new ExcelWriter();
        excelWriter.addModel(clazzs);
        return excelWriter;
    }

    public ExcelWriter addModel(Class<?> ... clazzs) {
        this.writerContext.addModel(clazzs);
        return this;
    }

    public ExcelWriter addData(List<?> ... data) {
        this.writerContext.addData(data);
        return this;
    }

    public void write(OutputStream os) throws IOException {
        Workbook workbook = this.execute();
        workbook.write(os);
    }

    public void write(HttpServletResponse response) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        Workbook workbook = this.execute();
        workbook.write(os);
        os.flush();
    }

    private Workbook execute() {
        return this.writerContext.getExecutor().executeWrite();
    }
}

