/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.support;

import cn.chenzw.excel.magic.core.context.AnnotationExcelReaderContext;
import cn.chenzw.excel.magic.core.support.callback.ExcelCellReadExceptionCallback;
import cn.chenzw.excel.magic.core.support.callback.ExcelRowReadExceptionCallback;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ExcelReader {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private ExcelRowReadExceptionCallback rowReadExceptionCallback;
    private ExcelCellReadExceptionCallback cellReadExceptionCallback;

    public ExcelReader(InputStream is) {
        try {
            IOUtils.copy((InputStream)is, (OutputStream)this.baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ExcelReader newInstance(InputStream is) {
        return new ExcelReader(is);
    }

    public ExcelReader configRowReadExceptionCallback(ExcelRowReadExceptionCallback rowReadExceptionCallback) {
        this.rowReadExceptionCallback = rowReadExceptionCallback;
        return this;
    }

    public ExcelReader configCellReadExceptionCallback(ExcelCellReadExceptionCallback cellReadExceptionCallback) {
        this.cellReadExceptionCallback = cellReadExceptionCallback;
        return this;
    }

    public <T> List<T> read(Class<T> clazz) {
        return new AnnotationExcelReaderContext(new ByteArrayInputStream(this.baos.toByteArray()), clazz, this.rowReadExceptionCallback, this.cellReadExceptionCallback).getExecutor().executeRead();
    }
}

