/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.meta.model;

import cn.chenzw.excel.magic.core.util.ExcelXmlCodecUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ExcelCellDefinition
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ExcelCellDefinition.class);
    private static final long serialVersionUID = -1737830792925662139L;
    private Integer sheetIndex;
    private Integer rowIndex;
    private Integer colIndex;
    private String colTitle;
    private String cellValue;
    private ExcelCellType cellType;

    public Integer getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(Integer sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Integer getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(Integer colIndex) {
        this.colIndex = colIndex;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(String colTitle) {
        this.colTitle = colTitle;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public ExcelCellType getCellType() {
        return this.cellType;
    }

    public void setCellType(ExcelCellType cellType) {
        this.cellType = cellType;
    }

    public String toString() {
        return "ExcelCell{sheetIndex=" + this.sheetIndex + ", rowIndex=" + this.rowIndex + ", colIndex=" + this.colIndex + ", colTitle='" + this.colTitle + '\'' + ", cellValue='" + this.cellValue + '\'' + ", cellType='" + this.cellType + '\'' + '}';
    }

    private static String getCellAttributes(Attributes attributes) {
        int length = attributes.getLength();
        ArrayList<String> attrs = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            attrs.add(attributes.getQName(i) + "=" + attributes.getValue(i));
        }
        return StringUtils.join(attrs);
    }

    public static class ExcelNullCellType
    implements ExcelCellType {
        private static final long serialVersionUID = 1030011032019218508L;

        @Override
        public boolean matches(String name, Attributes attributes) {
            if (logger.isDebugEnabled()) {
                logger.debug("The [{}] matches [{}]", (Object)ExcelCellDefinition.getCellAttributes(attributes), (Object)this.getClass().getName());
            }
            return true;
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelErrorCellType
    implements ExcelCellType {
        private static final long serialVersionUID = 9033391964718310293L;

        @Override
        public boolean matches(String name, Attributes attributes) {
            if ("c".equals(name) && "e".equals(attributes.getValue("t"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{}] matches [{}]", (Object)ExcelCellDefinition.getCellAttributes(attributes), (Object)this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelBooleanCellType
    implements ExcelCellType {
        private static final long serialVersionUID = -3049964850218918322L;

        @Override
        public boolean matches(String name, Attributes attributes) {
            if ("c".equals(name) && "b".equals(attributes.getValue("t"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{}] matches [{}]", (Object)ExcelCellDefinition.getCellAttributes(attributes), (Object)this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelInlinStrCellType
    implements ExcelCellType {
        private static final long serialVersionUID = 9115672114160103097L;

        @Override
        public boolean matches(String name, Attributes attributes) {
            if ("c".equals(name) && "inlineStr".equals(attributes.getValue("t"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{}] matches [{}]", (Object)ExcelCellDefinition.getCellAttributes(attributes), (Object)this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            XSSFRichTextString rtsi = new XSSFRichTextString(value);
            return rtsi.toString();
        }
    }

    public static class ExcelNumbericCellType
    implements ExcelCellType {
        private static final long serialVersionUID = -3254659667807688559L;
        private StylesTable stylesTable;

        public ExcelNumbericCellType(StylesTable stylesTable) {
            this.stylesTable = stylesTable;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            String dataFormat;
            if ("c".equals(name) && !StringUtils.isBlank(attributes.getValue("s")) && StringUtils.containsAny((CharSequence)(dataFormat = ExcelXmlCodecUtils.getDataFormat(Integer.parseInt(attributes.getValue("s")), this.stylesTable)), "#", "General")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{} - {}] matches [{}]!", ExcelCellDefinition.getCellAttributes(attributes), dataFormat, this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            return value;
        }
    }

    public static class ExcelDateCellType
    implements ExcelCellType {
        private static final long serialVersionUID = -9216501976104636864L;
        private StylesTable stylesTable;

        public ExcelDateCellType(StylesTable stylesTable) {
            this.stylesTable = stylesTable;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            int styleIndex;
            XSSFCellStyle cellStyle;
            String dataFormatString;
            if ("c".equals(name) && !StringUtils.isBlank(attributes.getValue("s")) && StringUtils.containsAny((CharSequence)(dataFormatString = (cellStyle = this.stylesTable.getStyleAt(styleIndex = Integer.parseInt(attributes.getValue("s")))).getDataFormatString()), "y", "m", "d", "h", "s", "Y", "M", "D")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{} - {}] matches [{}]!", ExcelCellDefinition.getCellAttributes(attributes), dataFormatString, this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            Date date = HSSFDateUtil.getJavaDate(Double.parseDouble(value));
            return DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss");
        }
    }

    public static class ExcelStringCellType
    implements ExcelCellType {
        private static final long serialVersionUID = 1368517956940674679L;
        private SharedStringsTable sst;

        public ExcelStringCellType(SharedStringsTable sst) {
            this.sst = sst;
        }

        @Override
        public boolean matches(String name, Attributes attributes) {
            if ("c".equals(name) && "s".equals(attributes.getValue("t"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The [{}] matches [{}]", (Object)ExcelCellDefinition.getCellAttributes(attributes), (Object)this.getClass().getName());
                }
                return true;
            }
            return false;
        }

        @Override
        public String getValue(String value) {
            int idx = Integer.parseInt(value);
            return new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
        }
    }

    public static interface ExcelCellType
    extends Serializable {
        public boolean matches(String var1, Attributes var2);

        public String getValue(String var1);
    }
}

