/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.meta.model;

import cn.chenzw.excel.magic.core.exception.ExcelException;
import cn.chenzw.excel.magic.core.exception.ExcelWriterException;
import cn.chenzw.excel.magic.core.meta.annotation.CellRange;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelComplexHeader;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExport;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExportColumn;
import cn.chenzw.excel.magic.core.meta.model.ExcelCellStyleDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelWriterSheetDefinition;
import cn.chenzw.excel.magic.core.util.ColorUtils;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class AnnotationExcelWriterSheetDefinition
implements ExcelWriterSheetDefinition {
    private Class<?> cls;
    private Map<Integer, Field> columnFields;
    private int firstDataRow = 1;
    private List<?> rowDatas;
    private int order;
    private String sheeName;
    private int maxRowsPerSheet;
    private boolean isRowStriped;
    private Color rowStripeColor;
    private int titleRowHeight;
    private int dataRowHeight;
    private Map<Integer, ExcelCellStyleDefinition> columnCellStyles;

    public AnnotationExcelWriterSheetDefinition(Class<?> clazz, List<?> rowDatas) {
        this.cls = clazz;
        this.columnFields = new HashMap<Integer, Field>();
        this.rowDatas = rowDatas;
        this.init();
    }

    private void init() {
        this.initSheetMeta();
        this.initColumnFields();
        this.firstDataRow = this.calFirstDataRow();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.cls.getAnnotation(clazz);
    }

    @Override
    public Class<?> getBindingModel() {
        return this.cls;
    }

    @Override
    public Map<Integer, Field> getColumnFields() {
        return this.columnFields;
    }

    @Override
    public Map<Integer, String> getColumnTitles() {
        return null;
    }

    @Override
    public int getFirstDataRow() {
        return this.firstDataRow;
    }

    @Override
    public List<?> getRowDatas() {
        return this.rowDatas;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getSheetName() {
        return this.sheeName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheeName = sheetName;
    }

    @Override
    public int getMaxRowsPerSheet() {
        return this.maxRowsPerSheet;
    }

    @Override
    public boolean isRowStriped() {
        return this.isRowStriped;
    }

    @Override
    public Color getRowStripeColor() {
        return this.rowStripeColor;
    }

    @Override
    public int getTitleRowHeight() {
        return this.titleRowHeight;
    }

    @Override
    public int getDataRowHeight() {
        return this.dataRowHeight;
    }

    @Override
    public Map<Integer, ExcelCellStyleDefinition> getColumnCellStyles(Workbook workbook) {
        block4: {
            if (this.columnCellStyles != null) break block4;
            this.columnCellStyles = new HashMap<Integer, ExcelCellStyleDefinition>();
            if (this.isRowStriped) {
                for (Map.Entry<Integer, Field> columnFieldEntry : this.columnFields.entrySet()) {
                    CellStyle oddCellStyle = workbook.createCellStyle();
                    ((XSSFCellStyle)oddCellStyle).setFillForegroundColor(new XSSFColor(this.rowStripeColor));
                    oddCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    this.columnCellStyles.put(columnFieldEntry.getKey() * 2 - 1, new ExcelCellStyleDefinition(oddCellStyle, workbook.createFont()));
                    this.columnCellStyles.put(columnFieldEntry.getKey() * 2, new ExcelCellStyleDefinition(workbook.createCellStyle(), workbook.createFont()));
                }
            } else {
                for (Map.Entry<Integer, Field> columnFieldEntry : this.columnFields.entrySet()) {
                    this.columnCellStyles.put(columnFieldEntry.getKey(), new ExcelCellStyleDefinition(workbook.createCellStyle(), workbook.createFont()));
                }
            }
        }
        return this.columnCellStyles;
    }

    private void initColumnFields() {
        Field[] fields;
        for (Field field : fields = this.cls.getDeclaredFields()) {
            ExcelExportColumn exportColumn = field.getAnnotation(ExcelExportColumn.class);
            if (exportColumn == null) continue;
            if (exportColumn.colIndex() < 1) {
                throw new ExcelException("The @ExcelExportColumn on Field [" + field.getName() + "] of Class[" + this.cls.getCanonicalName() + "] miss \"colIndex\" attribute or less than 1 !");
            }
            if (this.columnFields.containsKey(exportColumn.colIndex())) {
                throw new ExcelException("The @ExcelExportColumn on Field [" + field.getName() + "] of Class[" + this.cls.getCanonicalName() + "] has conflicting \"colIndex\" value => [" + exportColumn.colIndex() + "] !");
            }
            field.setAccessible(true);
            this.columnFields.put(exportColumn.colIndex(), field);
        }
    }

    private void initSheetMeta() {
        ExcelExport excelExport = this.cls.getAnnotation(ExcelExport.class);
        if (excelExport == null) {
            throw new ExcelWriterException("Class[" + this.cls.getCanonicalName() + "] miss @ExcelExport!");
        }
        this.order = excelExport.order();
        this.sheeName = excelExport.sheetName();
        this.maxRowsPerSheet = excelExport.maxRowsPerSheet();
        this.isRowStriped = excelExport.rowStriped();
        if (this.isRowStriped && !StringUtils.isBlank(excelExport.rowStripeColor())) {
            this.rowStripeColor = ColorUtils.hexToRgb(excelExport.rowStripeColor());
        }
        this.titleRowHeight = excelExport.titleRowHeight();
        this.dataRowHeight = excelExport.dataRowHeight();
    }

    private int calFirstDataRow() {
        ExcelComplexHeader complexHeader = this.cls.getAnnotation(ExcelComplexHeader.class);
        if (complexHeader != null) {
            CellRange[] cellRanges = complexHeader.value();
            int startRow = 1;
            for (CellRange cellRange : cellRanges) {
                if (cellRange.lastRow() <= startRow) continue;
                startRow = cellRange.lastRow();
            }
            return startRow + 1;
        }
        return 1;
    }

    public int compareTo(Object o) {
        AnnotationExcelWriterSheetDefinition sheetDefinition = (AnnotationExcelWriterSheetDefinition)o;
        if (this.order == sheetDefinition.getOrder()) {
            return 0;
        }
        if (this.order > sheetDefinition.getOrder()) {
            return 1;
        }
        return -1;
    }
}

