/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.executor;

import cn.chenzw.excel.magic.core.context.ExcelReaderContext;
import cn.chenzw.excel.magic.core.exception.ExcelReaderException;
import cn.chenzw.excel.magic.core.executor.AbstractExcelReaderExecutor;
import cn.chenzw.excel.magic.core.meta.model.ExcelRowDefinition;
import cn.chenzw.excel.magic.core.processor.ExcelPerRowProcessor;
import cn.chenzw.excel.magic.core.util.ExcelFieldUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReaderExecutor<T>
extends AbstractExcelReaderExecutor
implements ExcelPerRowProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExcelReaderExecutor.class);

    public ExcelReaderExecutor(ExcelReaderContext readerContext) {
        super(readerContext);
    }

    private void preProcess(ExcelRowDefinition row) {
        row.setSheetIndex(this.curSheetIndex);
        this.curRowIndex = row.getRowIndex();
        this.curSheet = this.readerContext.getSheetDefinitions().get(this.curSheetIndex);
    }

    @Override
    public void processTotalRow(int totalRows) {
        this.totalRows = totalRows;
        logger.info("total rows: {}", (Object)totalRows);
    }

    @Override
    public void processPerRow(ExcelRowDefinition row) {
        this.preProcess(row);
        if (this.isTitleRow(row)) {
            return;
        }
        if (!this.isEmptyRow(row)) {
            this.preSet(row);
            if (this.validate(row)) {
                this.format(row);
            }
        }
    }

    @Override
    protected ExcelPerRowProcessor getExcelRowProcess() {
        return this;
    }

    @Override
    public boolean isEmptyRow(ExcelRowDefinition row) {
        logger.debug("start validate empty row!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            if (super.isEmptyRow(row)) {
                logger.warn("Found empty row at [sheet={},row={}]", (Object)row.getSheetIndex(), (Object)row.getRowIndex());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            throw new ExcelReaderException(this.curSheetIndex, this.curRowIndex, this.curColIndex, ExcelFieldUtils.getCellValue(row, this.curColIndex), e.getMessage(), e);
        }
        finally {
            logger.debug("finish validate emtpy row! [cost:{}ms] ", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void preSet(ExcelRowDefinition row) {
        super.preSet(row);
    }

    @Override
    public boolean validate(ExcelRowDefinition row) {
        logger.debug("start validate empty row!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            boolean bl = super.validate(row);
            return bl;
        }
        catch (Throwable e) {
            throw new ExcelReaderException(this.curSheetIndex, this.curRowIndex, this.curColIndex, ExcelFieldUtils.getCellValue(row, this.curColIndex), e.getMessage(), e);
        }
        finally {
            logger.debug("finish validate empty row! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    public void format(ExcelRowDefinition row) {
        logger.debug("start format and assign value!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            super.format(row);
        }
        catch (Throwable e) {
            throw new ExcelReaderException(this.curSheetIndex, this.curRowIndex, this.curColIndex, ExcelFieldUtils.getCellValue(row, this.curColIndex), e.getMessage(), e);
        }
        finally {
            logger.debug("finish format and assign value! [cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }

    @Override
    protected boolean isTitleRow(ExcelRowDefinition row) {
        return super.isTitleRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeRead() {
        logger.debug("start read!");
        long startTimeMillis = System.currentTimeMillis();
        try {
            List list = super.executeRead();
            return list;
        }
        finally {
            logger.debug("finish read![total cost:{}ms]", (Object)(System.currentTimeMillis() - startTimeMillis));
        }
    }
}

