/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core;

import cn.chenzw.excel.magic.core.meta.annotation.ExcelDataFormat;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExport;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelExportColumn;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelImport;
import cn.chenzw.excel.magic.core.meta.annotation.ExcelImportColumn;
import cn.chenzw.excel.magic.core.support.ExcelReader;
import cn.chenzw.excel.magic.core.support.ExcelWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class App {
    private static final String DEFAULT_XLXS = "user.xlsx";

    public static void main(String[] args) throws IOException {
        App.handleExcelExport();
        App.handleExcelImport();
    }

    private static void handleExcelExport() throws IOException {
        String rows = "10000";
        if (NumberUtils.isCreatable(rows)) {
            long t1 = System.currentTimeMillis();
            long used1 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            long lRows = NumberUtils.toLong(rows);
            ArrayList<User> users = new ArrayList<User>();
            int i = 0;
            while ((long)i < lRows) {
                User user = new User();
                user.setName("\u5f20\u4e09" + i);
                user.setAge(i);
                user.setHeight(90.2);
                user.setBirth(Calendar.getInstance().getTime());
                users.add(user);
                ++i;
            }
            long used2 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            long t2 = System.currentTimeMillis();
            System.out.println("\u3010\u6784\u5efa\u6570\u636e\u3011 - \u8017\u65f6:" + (t2 - t1) + " ms");
            System.out.println("\u3010\u6784\u5efa\u6570\u636e\u3011 - \u8017\u8d39\u5185\u5b58:" + (used2 - used1) / 1024L / 1024L + " MB");
            File excelFile = new File(DEFAULT_XLXS);
            ExcelWriter.newInstance().addData(users).write(new FileOutputStream(excelFile));
            long used3 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            long t3 = System.currentTimeMillis();
            System.out.println("\u3010\u5bfc\u51faexcel\u3011 - \u8017\u65f6:" + (t3 - t2) + " ms");
            System.out.println("\u3010\u5bfc\u51faexcel\u3011 - \u8017\u8d39\u5185\u5b58:" + (used3 - used2) / 1024L / 1024L + " MB");
        } else {
            System.out.println("\u8bf7\u8f93\u5165\u6574\u6570!");
        }
    }

    private static void handleExcelImport() throws FileNotFoundException {
        File excelFile = new File(DEFAULT_XLXS);
        if (!excelFile.exists()) {
            System.out.println("\u5bfc\u5165\u7684excel\u4e0d\u5b58\u5728,\u8bf7\u5148\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd!");
            return;
        }
        long t1 = System.currentTimeMillis();
        long used1 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        List<User> users = ExcelReader.newInstance(new FileInputStream(excelFile)).read(User.class);
        System.out.println("\u6210\u529f\u8bfb\u53d6:" + users.size() + "\u6761\u6570\u636e");
        long t2 = System.currentTimeMillis();
        long used2 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        System.out.println("\u3010\u5bfc\u5165excel\u3011 - \u8017\u65f6:" + (t2 - t1) + " ms");
        System.out.println("\u3010\u5bfc\u5165excel\u3011 - \u8017\u8d39\u5185\u5b58:" + (used2 - used1) / 1024L / 1024L + " MB");
    }

    @ExcelImport(sheetIndex={1}, firstDataRow=2)
    @ExcelExport(sheetName="\u7528\u6237\u6570\u636e")
    public static class User {
        @ExcelExportColumn(colIndex=1, title="\u59d3\u540d")
        @ExcelImportColumn(colIndex=1)
        private String name;
        @ExcelExportColumn(colIndex=2, title="\u5e74\u9f84")
        @ExcelImportColumn(colIndex=2)
        private Integer age;
        @ExcelExportColumn(colIndex=3, title="\u751f\u65e5", dataFormat=@ExcelDataFormat(value="yyyy-MM-dd"))
        @ExcelImportColumn(colIndex=3, dateFormat="yyyy-MM-dd")
        private Date birth;
        @ExcelExportColumn(colIndex=4, title="\u4f53\u91cd", dataFormat=@ExcelDataFormat(value="0.00"))
        @ExcelImportColumn(colIndex=4)
        private Double height;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public Date getBirth() {
            return this.birth;
        }

        public void setBirth(Date birth) {
            this.birth = birth;
        }

        public Double getHeight() {
            return this.height;
        }

        public void setHeight(Double height) {
            this.height = height;
        }
    }
}

