/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ListUtils {
    public static <T> List<List<T>> split(List<T> data, Integer rowsPerSegment) {
        if (data.size() > rowsPerSegment) {
            int dataSize = data.size();
            int segmentCount = dataSize / rowsPerSegment;
            if (dataSize % rowsPerSegment > 0) {
                ++segmentCount;
            }
            ArrayList<List<T>> retList = new ArrayList<List<T>>();
            for (int i = 0; i < segmentCount; ++i) {
                int startIndex = i * rowsPerSegment;
                int endIndex = (i + 1) * rowsPerSegment;
                if (endIndex > dataSize) {
                    endIndex = dataSize;
                }
                retList.add(data.subList(startIndex, endIndex));
            }
            return retList;
        }
        return Collections.singletonList(data);
    }

    public static Class getGenericClass(List<?> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("collection size == 0");
        }
        return list.get(0).getClass();
    }
}

