/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.excel.magic.core.util;

import cn.chenzw.excel.magic.core.exception.ExcelException;
import cn.chenzw.excel.magic.core.meta.model.ExcelCellDefinition;
import cn.chenzw.excel.magic.core.meta.model.ExcelRowDefinition;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelFieldUtils {
    private static final String[] TRY_DATE_FORMAT_LIST = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss"};

    public static void setCellValue(Cell cell, Object o, Field field) throws IllegalAccessException {
        Object value = field.get(o);
        if (value == null) {
            return;
        }
        if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Short) {
            cell.setCellValue((double)((Short)value).shortValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u6570\u636e\u7c7b\u578b => [" + field.getType() + "]!");
        }
    }

    public static String getCellValue(ExcelRowDefinition row, int colIndex) {
        for (ExcelCellDefinition cell : row.getExcelCells()) {
            if (cell.getColIndex() != colIndex) continue;
            return cell.getCellValue();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFieldValue(Field field, Object o, Object cellValue, String dateFormat) throws IllegalAccessException, ParseException {
        if (field.getType() == String.class) {
            if (!StringUtils.isBlank((CharSequence)dateFormat)) {
                Date date = ExcelFieldUtils.tryParseDate((String)cellValue, dateFormat);
                field.set(o, DateFormatUtils.format((Date)date, (String)dateFormat));
                return;
            } else {
                field.set(o, cellValue);
            }
            return;
        } else if (field.getType() == Long.class) {
            field.set(o, cellValue);
            return;
        } else if (field.getType() == Integer.class) {
            if (cellValue instanceof String) {
                field.set(o, Integer.valueOf((String)cellValue));
                return;
            } else {
                field.set(o, cellValue);
            }
            return;
        } else if (field.getType() == Date.class) {
            if (cellValue instanceof String) {
                field.set(o, ExcelFieldUtils.tryParseDate((String)cellValue, "yyyy-MM-dd HH:mm:ss"));
                return;
            } else {
                if (!(cellValue instanceof Date)) throw new ExcelException("\u5b57\u6bb5[" + field.getName() + "]\u4e0d\u652f\u6301[" + cellValue.getClass() + "]\u7c7b\u578b!");
                field.set(o, cellValue);
            }
            return;
        } else if (field.getType() == Float.class) {
            field.set(o, cellValue);
            return;
        } else if (field.getType() == BigDecimal.class) {
            field.set(o, cellValue);
            return;
        } else {
            field.set(o, cellValue);
        }
    }

    private static Date tryParseDate(String dateValue, String tryDateFormat) throws ParseException {
        if (!StringUtils.isBlank((CharSequence)tryDateFormat)) {
            try {
                return DateUtils.parseDate((String)dateValue, (String[])new String[]{tryDateFormat});
            }
            catch (ParseException e) {
                for (String dateFormat : TRY_DATE_FORMAT_LIST) {
                    try {
                        return DateUtils.parseDate((String)dateValue, (String[])new String[]{dateFormat});
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
        }
        throw new ParseException("\u65e5\u671f\u8f6c\u6362\u5931\u8d25!", 0);
    }

    public static void main(String[] args) throws ParseException {
        Date date = DateUtils.parseDate((String)"2014/12/02", (String[])new String[]{"yyyy/MM/dd"});
        System.out.println(date);
    }
}

